<?php

// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//		Testimonials Carousel
// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

function vntd_logos($atts, $content = null) {
	extract(shortcode_atts(array(
		"images" => '',
		"onclick" => 'link_no',
		"custom_links" => '',
		'autoplay' => '6000',
		'slidespeed' => '700',
		'paginationspeed' => '900',
		'cols' => '5',
		'logo_max_height' => ''
	), $atts));

	wp_enqueue_script('owl-carousel', '', '', '', true);
	wp_enqueue_style('owl-carousel');

	$carousel_data = array();
	$carousel_data[] = 'data-carousel-autoplay="' . esc_attr( $autoplay ) . '"';
	$carousel_data[] = 'data-carousel-slidespeed="' . esc_attr( $slidespeed ) . '"';
	$carousel_data[] = 'data-carousel-paginationspeed="' . esc_attr( $paginationspeed ) . '"';
	$carousel_data[] = 'data-carousel-cols="' . esc_attr( $cols ) . '"';

	ob_start();

    ?>

	<div class="vntd-logos-carousel vntd-items-<?php echo esc_attr( $cols ); ?>">

		<div class="client-logos">

			<div class="logos boxed" <?php echo implode( ' ', $carousel_data ); ?>>

	<?php

	$link_href = '';

	if($onclick == 'custom_link') {
		$custom_links = explode(',',$custom_links);
	}

	$images = explode( ',', $images );
	$i = - 1;

	$style = '';
	if ( $logo_max_height != '' ) {
		$style = 'style="max-height:' . esc_attr( intval( str_replace( 'px', '', $logo_max_height ) ) ) . 'px;"';
	}

	foreach ( $images as $attach_id ) {

		$i ++;
		$link_href = '';
		if($onclick == 'custom_link') {
			$link_href = ' href="'.$custom_links[$i].'"';
		}
		$img = wp_get_attachment_image_src($attach_id, 'full');

		$logo_style = '';

		echo '<a'.$link_href.' class="item"><img ' . $style . 'src="' . esc_url( $img[0] ) . '" alt></a>';

	}


	echo '</div></div></div>';

	$content = ob_get_contents();
	ob_end_clean();

	return $content;

}
remove_shortcode('logos_carousel');
add_shortcode('logos_carousel', 'vntd_logos');
