<?php

// Recent Work Shortcode

function vntd_portfolio_carousel($atts, $content = null) {
	extract(shortcode_atts(array(
		"cats" => '',
		"posts_nr" => '6',
		"hover_style" => 'icons',
    'autoplay' => 'false',
    'slidespeed' => '700',
    'paginationspeed' => '900'
	), $atts));

	wp_enqueue_script('prettyPhoto', '', '', '', true);
	wp_enqueue_style('prettyPhoto');

	wp_enqueue_script('owl-carousel', '', '', '', true);
	wp_enqueue_style('owl-carousel');

    $carousel_data = array();
    $carousel_data[] = 'data-carousel-autoplay="' . esc_attr( $autoplay ) . '"';
    $carousel_data[] = 'data-carousel-slidespeed="' . esc_attr( $slidespeed ) . '"';
    $carousel_data[] = 'data-carousel-paginationspeed="' . esc_attr( $paginationspeed ) . '"';

	ob_start();

	echo '<div class="vntd-portfolio-carousel"><div class="works white" ' . implode( ' ', $carousel_data ) . '>';

	$size = 'portfolio-square';

	if ( has_filter( 'north_portfolio_carousel_image_size' ) ) {
		$size = apply_filters( 'north_portfolio_carousel_image_size', $image_size );
	}

	wp_reset_postdata();

	$args = array(
		'posts_per_page' => $posts_nr,
		'project-type'		=> $cats,
		'post_type' => 'portfolio',
		'orderby'	=> 'slug'
	);
	$the_query = new WP_Query($args);

	if ($the_query->have_posts()) : while ($the_query->have_posts()) : $the_query->the_post();

	$img_url = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), $size);
	$thumb_url = $img_url[0];

	$post_link_type = get_post_meta(get_the_ID(),'link_type',TRUE);

	$post_link = get_permalink();

        if ( $post_link_type == 'external' && get_post_meta( get_the_ID(),'portfolio_external_url',TRUE ) ) {
            $post_link = get_post_meta( get_the_ID(),'portfolio_external_url',TRUE );
        }
    ?>

        <!-- Item -->
        <div class="item">
            <?php if ( $hover_style == 'minimal' ) echo '<a href="' . esc_url( get_permalink() ) . '">'; ?>
            <!-- Image, Buttons -->
            <div class="f-image">
                <!-- Image -->
                <img src="<?php echo '' . $thumb_url; ?>" alt="<?php echo the_title(); ?>">

                <?php if ( $hover_style != 'minimal' ) { ?>
                <!-- Hover Tags, Link -->
                <div class="f-button first">
                    <a href="<?php echo '' . $post_link; ?>" class="featured-ball first ex-link">
                        <i class="fa fa-link"></i>
                    </a>
                </div>
                <!-- End Link -->

                <!-- Detail -->
                <div class="f-button second">
                    <a href="<?php echo '' . $thumb_url; ?>" data-rel="prettyPhoto[featured-work]"
                       class="featured-ball second">
                        <i class="fa fa-plus"></i>
                    </a>
                </div>
                <!-- End Detail -->
                <?php } ?>
            </div>
            <!-- End Image, Buttons -->

            <!-- Texts -->
            <div class="texts">
                <!-- Item Header -->
                <h3 class="f-head font-primary normal uppercase">
                    <?php the_title(); ?>
                </h3>

                <!-- Item Description -->
                <h4 class="f-text font-secondary normal">
                    <?php vntd_portfolio_overlay_categories(); ?>
                </h4>
            </div>
            <!-- End Texts -->
            <?php if ( $hover_style == 'minimal' ) echo '</a>'; ?>
        </div>
        <!-- End Item -->

    <?php


	endwhile; endif; wp_reset_postdata();

	echo '</div>';

	$content = ob_get_contents();
	ob_end_clean();

	return $content;

}
remove_shortcode('portfolio_carousel');
add_shortcode('portfolio_carousel', 'vntd_portfolio_carousel');
