<?php

// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
//		Testimonials Carousel
// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-

function vntd_testimonials($atts, $content = null) {
	extract(shortcode_atts(array(
		"posts_nr" => '6',
		"style" => 'simple',
		"autoplay" => '6000',
		"paginationspeed" => '900',
		"slideshowspeed" => '5000',
		"animationspeed" => '700'
	), $atts));

	wp_enqueue_script('owl-carousel', '', '', '', true);
	wp_enqueue_style('owl-carousel');

	ob_start();

    ?>

	<div class="vntd-testimonial-carousel">

	<?php if($style != 'expanded') { ?>

		<div class="testimonials t-center" data-slideshowspeed="<?php echo esc_attr( $slideshowspeed); ?>" data-animationspeed="<?php echo esc_attr( $animationspeed ); ?>">

		<a class="t-arrow"></a>

		<h2 class="quote white">
			<i class="fa fa-quote-right"></i>
		</h2>

		<ul class="text-slider clearfix">

	<?php } else {

		$carousel_data = array();
		$carousel_data[] = 'data-carousel-autoplay="' . esc_attr( $autoplay ) . '"';
		$carousel_data[] = 'data-carousel-paginationspeed="' . esc_attr( $paginationspeed ) . '"';

		?>

		<div class="clients t-center animated" data-animation="fadeIn" data-animation-delay="400" <?php echo implode( ' ', $carousel_data ); ?>>

	<?php }

	wp_reset_postdata();

	$args = array(
		'posts_per_page' => $posts_nr,
		'post_type' => 'testimonials'
	);
	$the_query = new WP_Query($args);

	if ($the_query->have_posts()) : while ($the_query->have_posts()) : $the_query->the_post();

	if($style != 'expanded') {

		echo '<li class="text normal"><h4 class="testimonial-content white">'.get_post_meta(get_the_id(), 'testimonial_content', true).'</h4>';
		echo '<p class="author uppercase">'.get_post_meta(get_the_id(), 'name', true).'</p></li>';

	} else {

		wp_enqueue_script('owl-carousel', '', '', '', true);
		wp_enqueue_style('owl-carousel');

		echo '<div class="item"><a class="client-image"><img src="'.vntd_thumb(130,130).'" class="round"></a><h4 class="client-name">'.get_post_meta(get_the_id(), 'name', true).'</h4><h5 class="client-position">'.get_post_meta(get_the_id(), 'role', true).'</h5>';
		echo '<p class="client-desc">'.get_post_meta(get_the_id(), 'testimonial_content', true).'</p></div>';

	}

	endwhile; endif; wp_reset_postdata();

	if($style != 'expanded') {
		echo '</ul></div>';
	} else {
		echo '</div>';
	}

	echo '</div>';

	$content = ob_get_contents();
	ob_end_clean();

	return $content;

}
remove_shortcode('testimonials');
add_shortcode('testimonials', 'vntd_testimonials');
