<?php
get_header();
$blog_style = '';
if( north_option( 'blog_layout' ) ) {
	$blog_style = north_option( 'blog_layout' );
}

$layout = get_post_meta(get_option('page_for_posts'), 'page_layout', true);
$content_inner_html = false;

?>

<div class="page-holder blog page-layout-<?php echo esc_attr( $layout ); ?>">

	<?php

	if(!is_front_page()) {

		$page_data = get_page(get_option('page_for_posts'));

		$content = apply_filters('the_content', $page_data->post_content);

		if ( $content ) {
			echo '<div class="blog-page-content">';
			if ( ! north_vc_active( $page_data->ID ) || north_option( 'vntd_vc_default' ) == true ) {
				$content_inner_html = true;
				echo '<div class="inner clearfix">';
			}
			echo '' . $content;
			if ( $content_inner_html === true ) {
				echo '</div>';
			}
			echo '</div>';
		}

	}

	?>

	<div id="blog" class="inner clearfix">

		<?php

		if($layout != "fullwidth") {
			echo '<div class="page_inner">';
		}

		if (have_posts()) : while (have_posts()) : the_post();

		 	vntd_blog_post_content();

		endwhile;

	    // Archive doesn't exist:
	    else :

	        esc_html_e('Nothing found, sorry.','north');

	    endif;

	    vntd_pagination();

    	if($layout != "fullwidth") {
    		echo '</div>';
    		get_sidebar();
    	}

    	?>
    </div>

</div>

<?php get_footer(); ?>
