<?php
/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @package	   TGM-Plugin-Activation
 * @subpackage Example
 * @version	   2.3.6
 * @author	   Thomas Griffin <thomas@thomasgriffinmedia.com>
 * @author	   Gary Jones <gamajo@gamajo.com>
 * @copyright  Copyright (c) 2012, Thomas Griffin
 * @license	   http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/thomasgriffin/TGM-Plugin-Activation
 */

/**
 * Include the TGM_Plugin_Activation class.
 */
require_once get_template_directory() . '/framework/plugins/class-tgm-plugin-activation.php';

add_action( 'tgmpa_register', 'north_theme_register_required_plugins' );
/**
 * Register the required plugins for this theme.
 *
 * In this example, we register two plugins - one included with the TGMPA library
 * and one from the .org repo.
 *
 * The variable passed to tgmpa_register_plugins() should be an array of plugin
 * arrays.
 *
 * This function is hooked into tgmpa_init, which is fired within the
 * TGM_Plugin_Activation class constructor.
 */
function north_theme_register_required_plugins() {

	/**
	 * Array of plugin arrays. Required keys are name and slug.
	 * If the source is NOT from the .org repo, then source is also required.
	 */
	$plugins = array(

		// North Core
		array(
			'name'			=> 'North Core', // The plugin name
			'slug'			=> 'north-core', // The plugin slug (typically the folder name)
			'source'			=> get_template_directory() . '/framework/plugins/lib/north-core.zip', // The plugin source
			'required'			=> true, // If false, the plugin is only 'recommended' instead of required
			'version'			=> '1.5.2', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
			'force_activation'		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
			'force_deactivation'	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			'external_url'		=> '', // If set, overrides default API URL and points to an external URL
		),
		// Visual Composer
    array(
        'name'			=> 'WPBakery Page Builder', // The plugin name
        'slug'			=> 'js_composer', // The plugin slug (typically the folder name)
        'source'			=> get_template_directory() . '/framework/plugins/lib/js_composer.zip', // The plugin source
        'required'			=> true, // If false, the plugin is only 'recommended' instead of required
        'version'			=> '6.6.0', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
        'force_activation'		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
        'force_deactivation'	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
        'external_url'		=> '', // If set, overrides default API URL and points to an external URL
    ),

    // Templatera
    array(
        'name'			=> 'Templatera', // The plugin name
        'slug'			=> 'templatera', // The plugin slug (typically the folder name)
        'source'			=> get_template_directory() . '/framework/plugins/lib/templatera.zip', // The plugin source
        'required'			=> true, // If false, the plugin is only 'recommended' instead of required
        'version'			=> '2.0.4', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
        'force_activation'		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
        'force_deactivation'	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
        'external_url'		=> '', // If set, overrides default API URL and points to an external URL
    ),

    // Revolution Slider
    array(
        'name'     				=> 'Revolution Slider', // The plugin name
        'slug'     				=> 'revslider', // The plugin slug (typically the folder name)
        'source'   				=> get_template_directory() . '/framework/plugins/lib/revslider.zip', // The plugin source
        'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
        'version' 				=> '6.4.2', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
        'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
    ),

		// Contact Form 7
		array(
			'name' 		=> 'Contact Form 7',
			'slug' 		=> 'contact-form-7',
			'required' 	=> true,
		),

		// Classic Editor
		array(
			'name' 			=> 'Classic Editor',
			'slug' 			=> 'classic-editor',
			'required' 	=> false,
		),

		// Envato Market
		array(
			'name'     				=> 'Envato Market', // The plugin name
			'slug'     				=> 'envato-market', // The plugin slug (typically the folder name)
			'source'   				=> get_template_directory() . '/framework/plugins/lib/envato-market.zip', // The plugin source
			'required' 				=> false, // If false, the plugin is only 'recommended' instead of required
			'version' 				=> '2.0.6', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
			'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
		),

	);

	// Change this to your theme text domain, used for internationalising strings
	$theme_text_domain = 'tgmpa';

	/**
	 * Array of configuration settings. Amend each line as needed.
	 * If you want the default strings to be available under your own theme domain,
	 * leave the strings uncommented.
	 * Some of the strings are added into a sprintf, so see the comments at the
	 * end of each line for what each argument will be.
	 */
	$config = array(
		'domain'       		=> $theme_text_domain,         	// Text domain - likely want to be the same as your theme.
		'default_path' 		=> '',                         	// Default absolute path to pre-packaged plugins
		'parent_slug' 	=> 'themes.php', 				// Default parent URL slug
		'menu'         		=> 'install-required-plugins', 	// Menu slug
		'has_notices'      	=> true,                       	// Show admin notices or not
		'is_automatic'    	=> false,					   	// Automatically activate plugins after installation or not
		'message'						=> '<div class="notice notice-info"><p>' . esc_html__( 'Note: If you cannot see an update for a particular bundled plugin, you can either find it in the newest theme package ("All files" package downloaded from ThemeForest) or use our', 'north' ) . ' <a href="https://plugins.veented.com/" target="_blank">Veented Plugins</a> ' . esc_html__( ' service.', 'north' ) . '</p></div>',
		'strings'      		=> array(
			'page_title'                       			=> 'Install Required Plugins',
			'menu_title'                       			=> 'Install Plugins',
			'installing'                       			=> 'Installing Plugin: %s', // %1$s = plugin name
			'oops'                             			=> 'Something went wrong with the plugin API.',
			'notice_can_install_required'     			=> _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.', 'north' ), // %1$s = plugin name(s)
			'notice_can_install_recommended'			=> _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.', 'north' ), // %1$s = plugin name(s)
			'notice_cannot_install'  					=> _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.', 'north' ), // %1$s = plugin name(s)
			'notice_can_activate_required'    			=> _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.', 'north' ), // %1$s = plugin name(s)
			'notice_can_activate_recommended'			=> _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.', 'north' ), // %1$s = plugin name(s)
			'notice_cannot_activate' 					=> _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.', 'north' ), // %1$s = plugin name(s)
			'notice_ask_to_update' 						=> _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.', 'north' ), // %1$s = plugin name(s)
			'notice_cannot_update' 						=> _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.', 'north' ), // %1$s = plugin name(s)
			'install_link' 					  			=> _n_noop( 'Begin installing plugin', 'Begin installing plugins', 'north' ),
			'activate_link' 				  			=> _n_noop( 'Activate installed plugin', 'Activate installed plugins', 'north' ),
			'return'                           			=> 'Return to Required Plugins Installer',
			'plugin_activated'                 			=> 'Plugin activated successfully.',
			'complete' 									=> 'All plugins installed and activated successfully. %s', // %1$s = dashboard link
			'nag_type'									=> 'updated' // Determines admin notice type - can only be 'updated' or 'error'
		)
	);

	tgmpa( $plugins, $config );

}
