<?php

$sidebar_id = get_post_meta(vntd_get_id(), 'page_sidebar', true);

if( is_archive() || is_search() ) {
	$sidebar_id = 'archives';
} elseif ( is_404() ) {
	global $smof_data;
	$sidebar_id = $smof_data['vntd_404_sidebar'];
}

if ( ! $sidebar_id || $sidebar_id == 'Default Sidebar' ) {
	$sidebar_id = 'default_sidebar';
}

if ( class_exists('Woocommerce') ) {
	if ( $sidebar_id && ( $sidebar_id == 'WooCommerce Shop Page' || $sidebar_id == 'woocommerce_shop' ) ) {
		$sidebar_id = 'woocommerce_shop';
	} else if ( $sidebar_id && ( $sidebar_id == 'WooCommerce Product Page' || $sidebar_id == 'woocommerce_product' ) ) {
		$sidebar_id = 'woocommerce_product';
	} else if ( is_woocommerce() || is_shop() || is_cart() || is_checkout() || is_account_page()) {
  	$sidebar_id = 'woocommerce_shop';
  } elseif ( is_product() ) {
  	$sidebar_id = 'woocommerce_product';
  }
}

?>

<div id="sidebar" class="page_sidebar">
	<?php
	if ( ! is_active_sidebar( $sidebar_id ) ) {
		esc_html_e( 'Please add widgets to your sidebar in Appearance / Widgets menu.', 'north' );
	} else {
		if ( ! function_exists('dynamic_sidebar') || !dynamic_sidebar( $sidebar_id ) );
	}
	?>
</div>
